import {
    EntityInitializationCause,
    EquipmentSlot,
    ItemLockMode,
    ItemStack,
    system,
    world
} from "@minecraft/server"


system.runInterval(() => {
    const players = world.getAllPlayers()
    players.forEach(player => {
        const playerInventory = player.getComponent("inventory").container
        const item = new ItemStack("test:test")
        item.nameTag = "Mine a grass block"
        playerInventory.setItem(0, item)
        if (player.getComponent("inventory").container.getItem(1) == undefined) {
            player.getComponent("inventory").container.setItem(1, new ItemStack("minecraft:redstone"))
        }
    })
})

world.afterEvents.entitySpawn.subscribe(event => {
    const entity = event.entity
    const players = world.getAllPlayers()
    if (event.cause == EntityInitializationCause.Spawned && !entity.spawnedFromEvent && entity.typeId == "minecraft:item") {
        if (entity.getComponent("item").itemStack.typeId == "minecraft:dirt") {
            players.forEach(player => {
                const newEntity = player.dimension.spawnItem(new ItemStack("minecraft:redstone"), player.location)
                newEntity.spawnedFromEvent = true
            })
        }
    }
})

world.beforeEvents.worldInitialize.subscribe(event => {
    event.itemComponentRegistry.registerCustomComponent("compact:test", {
        onMineBlock: (event) => {
            const player = event.source
            player.getComponent("equippable").getEquipmentSlot(EquipmentSlot.Mainhand).setItem(undefined)
        }
    })
})